<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Flower V-Card</title>
    <!-- BOOTSTRAP LINK CSS -->
    {{--  <link rel="stylesheet" href="{{ asset('assets/css/bootstrap-datepicker.min.css') }}" /> --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="{{ asset('assets/css/vcard37.css') }}">
    <link rel="stylesheet" href="{{ asset('front/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick-theme.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick-theme.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/custom.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/third-party.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/plugins.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/custom-vcard.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/lightbox.css') }}">
</head>

<body>
    <div class="main-section position-relative m-auto">
        <div class="sticky position-sticky top-50 h-0 overflow-visible">
            <button
                class="menu-btn d-flex justify-content-center align-items-center rounded-circle border-0 btn1 position-absolute top-50">
                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"
                    fill="none">
                    <path
                        d="M15.4135 0.540527H22.4891C23.5721 0.540527 24.4602 1.42867 24.4602 2.51164V9.58726C24.4602 10.6774 23.5732 11.5584 22.4891 11.5584H15.4135C14.3223 11.5584 13.4424 10.6785 13.4424 9.58726V2.51164C13.4424 1.42758 14.3234 0.540527 15.4135 0.540527Z"
                        stroke="#ffffff" />
                    <path
                        d="M2.97143 0.5H8.74589C10.1129 0.5 11.2173 1.6122 11.2173 2.97143V8.74589C11.2173 10.1139 10.1139 11.2173 8.74589 11.2173H2.97143C1.6122 11.2173 0.5 10.1129 0.5 8.74589V2.97143C0.5 1.61328 1.61328 0.5 2.97143 0.5Z"
                        stroke="#ffffff" />
                    <path
                        d="M2.97143 13.783H8.74589C10.1139 13.783 11.2173 14.8863 11.2173 16.2544V22.0289C11.2173 23.3881 10.1129 24.5003 8.74589 24.5003H2.97143C1.61328 24.5003 0.5 23.387 0.5 22.0289V16.2544C0.5 14.8874 1.6122 13.783 2.97143 13.783Z"
                        stroke="#ffffff" />
                    <path
                        d="M16.2537 13.783H22.0281C23.3873 13.783 24.4995 14.8874 24.4995 16.2544V22.0289C24.4995 23.387 23.3863 24.5003 22.0281 24.5003H16.2537C14.8867 24.5003 13.7822 23.3881 13.7822 22.0289V16.2544C13.7822 14.8863 14.8856 13.783 16.2537 13.783Z"
                        stroke="#ffffff" />
                </svg>
            </button>
            <span class="social position-absolute">
                <div class="whatsapp-icon mb-30px rounded-circle">
                    <div class="bg-teal-green h-100 w-100 rounded-circle d-flex justify-content-center align-items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"
                            fill="none" class="bg-teal-green">
                            <path
                                d="M21.3057 3.63045C18.955 1.2907 15.8277 0.00133515 12.4994 0C9.17859 0 6.04639 1.28822 3.68014 3.6274C1.3097 5.97057 0.00305469 9.08451 0 12.3842V12.388V12.3903C0.000381837 14.3875 0.525598 16.4022 1.52257 18.2413L0.0341744 25L6.87726 23.4449C8.61042 24.3176 10.5442 24.7776 12.4947 24.7784H12.4996C15.8199 24.7784 18.9521 23.49 21.3187 21.1506C23.6913 18.8055 24.9985 15.6956 25 12.3938C25.001 9.11522 23.6892 6.003 21.3057 3.63045ZM12.4994 22.8271H12.495C10.7437 22.8264 9.00848 22.3871 7.47713 21.5565L7.15352 21.381L2.60317 22.415L3.59156 17.9274L3.40102 17.5991C2.45368 15.967 1.9531 14.1653 1.9531 12.3882C1.95672 6.63624 6.6873 1.95122 12.499 1.95122C15.3067 1.95236 17.9448 3.03974 19.9273 5.0127C21.9398 7.01618 23.0477 9.63726 23.0467 12.3932C23.0444 18.1465 18.3129 22.8271 12.4994 22.8271Z"
                                fill="url(#paint0_linear_4098_691)" />
                            <path
                                d="M9.09818 6.92676H8.55024C8.35951 6.92676 8.04984 6.99809 7.7879 7.28286C7.52577 7.56782 6.78711 8.25656 6.78711 9.65732C6.78711 11.0581 7.81177 12.4115 7.95458 12.6017C8.09757 12.7917 9.93249 15.758 12.8387 16.8991C15.254 17.8475 15.7456 17.6588 16.2696 17.6113C16.7939 17.564 17.9614 16.9228 18.1996 16.2581C18.4379 15.5934 18.4379 15.0235 18.3665 14.9044C18.2949 14.7858 18.1042 14.7147 17.8184 14.5724C17.5324 14.4299 16.131 13.7295 15.8689 13.6343C15.6068 13.5395 15.4162 13.492 15.2255 13.7772C15.0348 14.0618 14.4733 14.7202 14.3064 14.9102C14.1398 15.1003 13.9729 15.1242 13.6869 14.9817C13.4009 14.8388 12.4895 14.5329 11.3972 13.5632C10.5471 12.8084 9.95712 11.846 9.79026 11.561C9.62358 11.2763 9.7725 11.1222 9.91588 10.9801C10.0444 10.8527 10.2179 10.6783 10.3609 10.5122C10.5037 10.3459 10.5444 10.2272 10.6398 10.0373C10.7351 9.84729 10.6874 9.68097 10.616 9.53868C10.5444 9.3962 9.99568 7.98839 9.74138 7.42534H9.74157C9.52736 6.95117 9.30189 6.93515 9.09818 6.92676Z"
                                fill="url(#paint1_linear_4098_691)" />
                            <defs>
                                <lineargradient id="paint0_linear_4098_691" x1="15.121" y1="-8.95833" x2="-2.9946"
                                    y2="-1.25231" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#ffffff" />
                                    <stop offset="1" stop-color="#ffffff" />
                                </lineargradient>
                                <lineargradient id="paint1_linear_4098_691" x1="13.8159" y1="3.0812" x2="5.61204"
                                    y2="6.86013" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#ffffff" />
                                    <stop offset="1" stop-color="#ffffff" />
                                </lineargradient>
                            </defs>
                        </svg>
                    </div>
                </div>
                <div class="send-icon rounded-circle">
                    <div class="bg-teal-green h-100 w-100 rounded-circle d-flex justify-content-center align-items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="23" height="25" viewBox="0 0 23 25"
                            fill="none" class>
                            <path
                                d="M18.6875 16.2109C17.2672 16.2109 16.0156 16.9229 15.2295 18.0056L8.43285 14.4592C8.5457 14.0672 8.625 13.661 8.625 13.2324C8.625 12.6511 8.50803 12.0984 8.30597 11.59L15.419 7.22832C16.2105 8.175 17.3741 8.78906 18.6875 8.78906C21.0656 8.78906 23 6.81782 23 4.39453C23 1.97124 21.0656 0 18.6875 0C16.3094 0 14.375 1.97124 14.375 4.39453C14.375 4.95298 14.4878 5.48272 14.6751 5.97451L7.54089 10.349C6.74997 9.43047 5.60323 8.83789 4.3125 8.83789C1.93444 8.83789 0 10.8091 0 13.2324C0 15.6557 1.93444 17.627 4.3125 17.627C5.75623 17.627 7.02894 16.8941 7.81209 15.781L14.5864 19.3159C14.4616 19.7263 14.375 20.1538 14.375 20.6055C14.375 23.0288 16.3094 25 18.6875 25C21.0656 25 23 23.0288 23 20.6055C23 18.1822 21.0656 16.2109 18.6875 16.2109Z"
                                fill="url(#paint0_linear_4098_697)" />
                            <defs>
                                <lineargradient id="paint0_linear_4098_697" x1="13.9113" y1="-8.95833" x2="-3.15673"
                                    y2="-2.27875" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#ffffff" />
                                    <stop offset="1" stop-color="#ffffff" />
                                </lineargradient>
                            </defs>
                        </svg>
                    </div>
                </div>
            </span>
        </div>
        <div class="main-img h-100 w-100 position-relative">
            <img src="{{ asset('assets/img/vcard37/main.png') }}" class="h-100 w-100 object-fit-cover"
                alt="images" />
        </div>
        <!-- introduction-section -->
        <div class="introduction-section px-30px position-relative mb-20px">
            <div class="position-absolute vector-75 hero-vector-1 text-end">
                <img src="{{ asset('assets/img/vcard37/hero-vector-1.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute hero-vector-2">
                <img src="{{ asset('assets/img/vcard37/hero-vector-2.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute hero-vector-3">
                <img src="{{ asset('assets/img/vcard37/hero-vector-3.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute hero-vector-4">
                <img src="{{ asset('assets/img/vcard37/hero-vector-4.png') }}" alt="images" class="w-100" />
            </div>
            <div class="d-block d-sm-flex align-items-end gap-30">
                <div class="intro-box position-relative h-100 w-100 mx-auto mx-sm-0 mb-3 mb-sm-0">
                    <div class="position-absolute intro-vector-1">
                        <img src="{{ asset('assets/img/vcard37/intro-vector-1.png') }}" alt="images"
                            class="h-100 w-100 object-fit-cover" />
                    </div>
                    <div class="intro-img w-100 h-100">
                        <img src="{{ asset('assets/img/vcard37/intro-img.png') }}" alt="image"
                            class="h-100 w-100 object-fit-cover" />
                    </div>
                    <div class="position-absolute intro-vector-2">
                        <img src="{{ asset('assets/img/vcard37/intro-vector-2.png') }}" alt="images"
                            class="h-100 w-100 object-fit-cover" />
                    </div>
                </div>
                <div>
                    <p class="fw-semibold text-teal-green fs-30 mb-5px text-center text-sm-start lh-12">Jenny
                        Wilson</p>
                    <p class="text-black fs-18 fw-semibold vcard-name text-center text-sm-start lh-12">Flower
                        Garden</p>
                </div>
            </div>
        </div>
        <!-- social-section -->
        <div class="social-section px-30px pb-60px">
            <div class="d-flex gap-30 flex-wrap justify-content-center align-items-center mb-20px">
                <a href="#"
                    class="text-decoration-none d-flex justify-content-center align-items-center social-box rounded-circle">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26"
                        fill="none">
                        <g clip-path="url(#clip0_5891_1834)">
                            <path
                                d="M14.9694 25.4998C14.9694 22.5882 14.9694 19.6825 14.9694 16.7413C15.9426 16.7413 16.8925 16.7413 17.8657 16.7413C18.0533 15.5188 18.2351 14.3257 18.4227 13.0973C17.2618 13.0973 16.1244 13.0973 15.0104 13.0973C15.0104 12.0992 14.9401 11.1365 15.028 10.1857C15.1042 9.35292 15.7961 8.83319 16.6697 8.78594C17.1856 8.75641 17.7074 8.76823 18.2234 8.76823C18.3289 8.76823 18.4344 8.76823 18.5517 8.76823C18.5517 7.71696 18.5517 6.70113 18.5517 5.66168C17.2325 5.50222 15.9309 5.28961 14.6117 5.53175C12.6769 5.89202 11.3343 7.28583 11.135 9.27023C11.0236 10.4042 11.0705 11.5499 11.047 12.6898C11.047 12.8138 11.047 12.9378 11.047 13.0973C9.97407 13.0973 8.93631 13.0973 7.88683 13.0973C7.88683 14.3257 7.88683 15.5188 7.88683 16.7413C8.94218 16.7413 9.97407 16.7413 11.0236 16.7413C11.0236 19.6766 11.0236 22.5823 11.0236 25.4939C6.61455 25.0097 0.968441 20.8873 0.528712 13.9064C0.0713952 6.71885 5.53575 0.877845 12.3193 0.51758C19.6422 0.127786 25.4642 6.00423 25.5053 13.0028C25.5404 19.9423 20.1816 24.8502 14.9694 25.4998Z" />
                        </g>
                        <defs>
                            <clippath id="clip0_5891_1834">
                                <rect width="25" height="25" fill="white" transform="translate(0.5 0.5)" />
                            </clippath>
                        </defs>
                    </svg>
                </a>
                <a href="#"
                    class="text-decoration-none d-flex justify-content-center align-items-center social-box rounded-circle">
                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22"
                        fill="none">
                        <g clip-path="url(#clip0_5891_1850)">
                            <path
                                d="M0.166016 21.8325C0.199885 21.7072 0.219239 21.6253 0.243431 21.5433C0.707924 19.8615 1.17242 18.1844 1.62723 16.5026C1.6611 16.3724 1.64175 16.1941 1.57885 16.0785C-0.525885 12.1606 -0.148485 7.54868 2.70137 4.13194C5.28995 1.01398 8.66721 -0.263082 12.6928 0.291114C15.2959 0.652546 17.4442 1.89587 19.1812 3.85243C22.573 7.68361 22.7133 13.4232 19.5634 17.4953C16.4668 21.5 10.8155 22.8059 6.28184 20.5361C5.99153 20.3916 5.74477 20.3675 5.43511 20.4542C3.77551 20.9024 2.11592 21.3265 0.451485 21.7602C0.37407 21.7795 0.291816 21.7987 0.166016 21.8325ZM5.52704 8.49322C5.60445 8.85947 5.65768 9.23536 5.75929 9.59679C5.96734 10.3197 6.4028 10.922 6.83343 11.5244C8.32368 13.6063 10.2058 15.158 12.7122 15.8809C13.7573 16.1797 14.7395 16.1411 15.6636 15.4905C16.3071 15.0376 16.5152 14.4062 16.5055 13.6737C16.5055 13.5533 16.4088 13.3798 16.3071 13.3268C15.5814 12.9605 14.8459 12.6087 14.1056 12.2714C13.8153 12.1365 13.6799 12.1943 13.4815 12.4497C13.225 12.7726 12.9686 13.0906 12.7073 13.4039C12.5622 13.5822 12.3832 13.6448 12.1509 13.5533C10.5397 12.9171 9.30588 11.8473 8.43012 10.363C8.314 10.1703 8.32368 10.0112 8.47851 9.84257C8.66721 9.63534 8.84623 9.41848 9.02041 9.19681C9.24298 8.90766 9.29621 8.60888 9.1317 8.25708C8.89461 7.7559 8.70108 7.23543 8.48334 6.72461C8.15433 5.9391 8.15433 5.91982 7.29308 5.94873C7.06083 5.95837 6.78504 6.04512 6.6157 6.19451C5.91896 6.79208 5.56575 7.56313 5.52704 8.49322Z" />
                        </g>
                        <defs>
                            <clippath id="clip0_5891_1850">
                                <rect width="21.6667" height="21.6667" fill="white"
                                    transform="translate(0.166016 0.166664)" />
                            </clippath>
                        </defs>
                    </svg>
                </a>
                <a href="#"
                    class="text-decoration-none d-flex justify-content-center align-items-center social-box rounded-circle">
                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22"
                        fill="none">
                        <g clip-path="url(#clip0_5891_1844)">
                            <path
                                d="M17.3423 21.8237C17.3423 21.7078 17.3423 21.6016 17.3423 21.5001C17.3423 19.1582 17.3519 16.8162 17.3327 14.4743C17.3279 13.8804 17.2749 13.2816 17.1594 12.7021C16.9331 11.5625 16.2688 11.0266 15.1087 10.9783C14.3626 10.9445 13.6646 11.0893 13.1255 11.6543C12.6682 12.1323 12.4708 12.7359 12.3986 13.383C12.3456 13.8707 12.3216 14.3632 12.3216 14.8509C12.3119 17.0818 12.3168 19.3079 12.3168 21.5388C12.3168 21.6305 12.3168 21.7271 12.3168 21.8333C10.8149 21.8333 9.34187 21.8333 7.84961 21.8333C7.84961 17.0142 7.84961 12.1999 7.84961 7.37601C9.27448 7.37601 10.6897 7.37601 12.1387 7.37601C12.1387 8.02306 12.1387 8.66046 12.1387 9.29786C12.1579 9.30269 12.1724 9.30752 12.1916 9.31234C12.2301 9.26406 12.2686 9.2206 12.3023 9.17231C13.0773 7.93615 14.223 7.27943 15.6334 7.0718C16.6491 6.92211 17.6504 7.00902 18.6324 7.31806C20.0428 7.76231 20.9045 8.74255 21.357 10.1187C21.6891 11.1231 21.8047 12.1613 21.8143 13.214C21.8335 16.0388 21.8287 18.8636 21.8287 21.6885C21.8287 21.7271 21.8239 21.7657 21.8191 21.8333C20.3413 21.8237 18.8635 21.8237 17.3423 21.8237Z" />
                            <path
                                d="M0.546875 7.37601C2.04395 7.37601 3.51696 7.37601 4.99959 7.37601C4.99959 12.1999 4.99959 17.0094 4.99959 21.8333C3.51214 21.8333 2.03914 21.8333 0.546875 21.8333C0.546875 17.019 0.546875 12.2048 0.546875 7.37601Z" />
                            <path
                                d="M5.35902 2.76937C5.36383 4.218 4.20372 5.38173 2.75959 5.38173C1.32028 5.38173 0.155357 4.21317 0.160171 2.76937C0.169799 1.3304 1.32028 0.171493 2.75478 0.166664C4.19409 0.161835 5.35902 1.32074 5.35902 2.76937Z" />
                        </g>
                        <defs>
                            <clippath id="clip0_5891_1844">
                                <rect width="21.6667" height="21.6667" fill="white"
                                    transform="translate(0.166016 0.166664)" />
                            </clippath>
                        </defs>
                    </svg>
                </a>
                <a href="#"
                    class="text-decoration-none d-flex justify-content-center align-items-center social-box rounded-circle">
                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22"
                        fill="none">
                        <g clip-path="url(#clip0_5891_1838)">
                            <path
                                d="M5.7191 0.166664C9.24996 0.166664 12.7648 0.166664 16.2956 0.166664C16.5203 0.198739 16.745 0.230814 16.9537 0.278927C19.4092 0.824202 20.9821 2.31569 21.6561 4.73735C21.7364 5.0581 21.7685 5.37885 21.8327 5.71564C21.8327 9.24389 21.8327 12.7561 21.8327 16.2844C21.8166 16.3645 21.8166 16.4287 21.7845 16.5089C21.6401 17.0702 21.5759 17.6636 21.3351 18.1928C20.2598 20.5343 18.3981 21.7692 15.8302 21.8173C12.6203 21.8654 9.39441 21.8333 6.18453 21.8333C4.93268 21.8333 3.77713 21.4965 2.76602 20.7749C1.03268 19.5239 0.182065 17.84 0.166016 15.723C0.166016 12.5637 0.166016 9.40426 0.166016 6.26091C0.166016 5.85998 0.182065 5.443 0.278361 5.04206C0.82404 2.58833 2.31663 1.01665 4.74009 0.343077C5.06108 0.262889 5.38206 0.230814 5.7191 0.166664ZM2.09194 10.992C2.09194 12.5637 2.09194 14.1193 2.09194 15.691C2.09194 16.1881 2.14009 16.6693 2.31663 17.1504C2.92651 18.8664 4.40305 19.9088 6.26478 19.9088C9.42651 19.9088 12.5882 19.9249 15.7339 19.9088C16.1993 19.9088 16.6969 19.8447 17.1463 19.6843C18.8796 19.107 19.9068 17.5994 19.9068 15.723C19.9068 12.5797 19.9228 9.4203 19.8907 6.27695C19.8907 5.81186 19.8265 5.3147 19.6821 4.86565C19.1043 3.1336 17.6117 2.09116 15.75 2.09116C12.5882 2.09116 9.42651 2.09116 6.24873 2.09116C4.83639 2.09116 3.68083 2.65248 2.83021 3.80718C2.28453 4.5449 2.07589 5.37885 2.07589 6.29299C2.09194 7.84863 2.09194 9.4203 2.09194 10.992Z" />
                            <path
                                d="M10.9992 16.573C7.93382 16.573 5.41406 14.0551 5.41406 10.992C5.41406 7.92881 7.94986 5.41093 10.9992 5.41093C14.0647 5.42696 16.5684 7.91278 16.5684 10.9759C16.6005 14.0391 14.0807 16.557 10.9992 16.573ZM14.6585 10.992C14.6585 8.98729 13.0215 7.33543 10.9992 7.33543C8.99307 7.33543 7.33999 8.97125 7.33999 10.992C7.33999 12.9967 8.97703 14.6485 10.9992 14.6485C13.0054 14.6485 14.6585 13.0127 14.6585 10.992Z" />
                            <path
                                d="M16.8091 3.79116C17.5795 3.79116 18.2375 4.43266 18.2215 5.20246C18.2215 5.97226 17.5795 6.59772 16.8091 6.59772C16.0387 6.59772 15.3807 5.95622 15.3968 5.18642C15.4128 4.41662 16.0387 3.79116 16.8091 3.79116Z" />
                        </g>
                        <defs>
                            <clippath id="clip0_5891_1838">
                                <rect width="21.6667" height="21.6667" fill="white"
                                    transform="translate(0.166016 0.166664)" />
                            </clippath>
                        </defs>
                    </svg>
                </a>
                <a href="#"
                    class="text-decoration-none d-flex justify-content-center align-items-center social-box rounded-circle">
                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="19" viewBox="0 0 22 19"
                        fill="none">
                        <g clip-path="url(#clip0_5891_1854)">
                            <path
                                d="M6.57018 14.8052C4.53649 14.5412 3.18721 13.583 2.42458 11.6667C3.07966 11.6667 3.65653 11.6667 4.22361 11.6667C2.16059 10.8552 0.997081 9.43744 0.85042 7.18864C1.47617 7.36463 2.05304 7.53085 2.6299 7.68729C2.65923 7.64818 2.68857 7.60907 2.7179 7.56996C1.85749 6.87577 1.24152 6.01536 1.02641 4.92029C0.811311 3.82522 0.909084 2.76927 1.5055 1.68398C3.9694 4.49009 6.98083 6.12291 10.6865 6.35756C10.6865 5.94691 10.6767 5.59493 10.6865 5.24294C10.7451 3.37546 11.6642 2.01641 13.3361 1.26355C14.9689 0.530248 16.5724 0.725796 17.9804 1.87953C18.3715 2.20218 18.7235 2.27062 19.1634 2.09463C19.8381 1.83064 20.5127 1.56665 21.246 1.29288C20.9331 2.27062 20.2878 2.93548 19.6132 3.65901C20.3172 3.47324 21.0211 3.27769 21.7251 3.09192C21.7544 3.12125 21.7936 3.15059 21.8229 3.17992C21.2656 3.75678 20.7376 4.38253 20.1314 4.90074C19.799 5.18428 19.6719 5.46782 19.6621 5.88825C19.6034 8.83124 18.7235 11.5005 16.9049 13.8275C14.4605 16.966 11.2144 18.55 7.21549 18.6282C4.92759 18.6771 2.78634 18.198 0.772201 17.1127C0.576654 17.0051 0.381106 16.8878 0.175781 16.7216C2.49302 16.8291 4.60493 16.2816 6.57018 14.8052Z" />
                        </g>
                        <defs>
                            <clippath id="clip0_5891_1854">
                                <rect width="21.6667" height="17.7948" fill="white"
                                    transform="translate(0.166016 0.833336)" />
                            </clippath>
                        </defs>
                    </svg>
                </a>
            </div>
            <p class="fs-14 fw-medium text-gray mb-0 text-center">Lorem Ipsum is
                simply dummy text of the printing and
                typesetting industry. Lorem Ipsum has been the industry's standard
                dummy text ever since the 1500s, when an
                unknown printer took a galley of type and scrambled it to make a type
                specimen book.</p>
        </div>
        <!-- personal-details -->
        <div class="personal-details bg-white position-relative">
            <div class="position-absolute personal-vector-1">
                <img src="{{ asset('assets/img/vcard37/personal-vector-1.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute personal-vector-2 text-end">
                <img src="{{ asset('assets/img/vcard37/personal-vector-2.png') }}" alt="images" class="w-100" />
            </div>
            <div class="row position-relative row-gap-3 row-gap-sm-0">
                <div class="col-sm-6">
                    <a href="mailto:john@gmail.com" class="text-decoration-none">
                        <div class="box-1 d-flex align-items-center gap-15">
                            <div class="icon1 d-flex align-items-center justify-content-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="18"
                                    viewBox="0 0 22 18" fill="none">
                                    <g clip-path="url(#clip0_5893_1974)">
                                        <path
                                            d="M11.0203 0.666245C13.7793 0.666245 16.5328 0.660688 19.2917 0.671803C19.6526 0.671803 20.019 0.710705 20.3687 0.788508C20.996 0.933001 21.429 1.33313 21.701 1.9111C21.9397 2.41683 21.862 2.6947 21.3957 2.98924C20.7906 3.3727 20.18 3.75061 19.5749 4.13407C16.9325 5.81796 14.29 7.49074 11.6587 9.18575C11.1813 9.49697 10.8038 9.48585 10.3264 9.18019C7.12333 7.11839 3.90359 5.08438 0.689394 3.03926C0.622778 2.9948 0.550612 2.9559 0.489548 2.91144C0.173124 2.6947 0.11206 2.52242 0.223086 2.16119C0.495099 1.272 1.17236 0.755164 2.16604 0.69959C2.56573 0.67736 2.96542 0.67736 3.35956 0.671803C5.91315 0.671803 8.46674 0.671803 11.0203 0.666245C11.0203 0.671803 11.0203 0.666245 11.0203 0.666245Z"
                                            fill="#006769" />
                                        <path
                                            d="M10.9736 17.3333C8.17024 17.3333 5.37239 17.3389 2.56899 17.3278C2.21926 17.3278 1.85843 17.2889 1.5198 17.1944C0.836991 16.9999 0.415094 16.5164 0.209696 15.8439C0.104222 15.4938 0.165286 15.3216 0.481709 15.1215C3.06861 13.4932 5.65551 11.8648 8.24241 10.2365C8.51442 10.0642 8.80309 10.0642 9.0751 10.2254C9.56361 10.5144 10.041 10.8145 10.5184 11.1201C10.9126 11.3758 11.0791 11.3813 11.4622 11.1313C11.9673 10.8034 12.478 10.4866 12.9832 10.1587C13.2552 9.98088 13.4995 10.0365 13.7493 10.1976C14.5764 10.7311 15.4036 11.2591 16.2363 11.787C17.9349 12.8652 19.6392 13.9322 21.3379 15.0103C21.8597 15.3382 21.943 15.6105 21.6876 16.1607C21.3379 16.9054 20.705 17.2222 19.9334 17.3167C19.7391 17.3389 19.5448 17.3389 19.3505 17.3389C16.5582 17.3333 13.7659 17.3333 10.9736 17.3333Z"
                                            fill="#006769" />
                                        <path
                                            d="M0.205078 13.4709C0.205078 10.4811 0.205078 7.54118 0.205078 4.5513C2.54772 6.04624 4.85706 7.5134 7.20525 9.00834C4.86261 10.5033 2.55327 11.976 0.205078 13.4709Z"
                                            fill="#006769" />
                                        <path
                                            d="M14.8105 9.00834C17.1476 7.51896 19.457 6.04624 21.7996 4.5513C21.7996 7.53007 21.7996 10.4644 21.7996 13.4598C19.4625 11.976 17.1532 10.5033 14.8105 9.00834Z"
                                            fill="#006769" />
                                    </g>
                                    <defs>
                                        <clippath id="clip0_5893_1974">
                                            <rect width="21.6667" height="16.6667" fill="white"
                                                transform="translate(0.166016 0.666656)" />
                                        </clippath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="box1-content fs-16 fw-medium lh-base text-black text-break">
                                jenny@gmail.com
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-sm-6">
                    <a href="tel:+1 1234567890" class="text-decoration-none">
                        <div class="box-1 d-flex align-items-center gap-15">
                            <div class="icon1 d-flex align-items-center justify-content-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                    viewBox="0 0 22 22" fill="none">
                                    <g clip-path="url(#clip0_5893_1968)">
                                        <path
                                            d="M4.54095 9.54438C6.32071 12.958 8.84849 15.5472 12.1888 17.3248C12.3306 17.4021 12.666 17.3119 12.8078 17.1831C13.5687 16.4617 14.3167 15.7275 15.039 14.9675C15.4388 14.5424 15.8773 14.478 16.4318 14.581C17.7473 14.8129 19.0757 15.0448 20.404 15.1994C21.4616 15.3282 21.8356 15.676 21.8356 16.758C21.8356 17.9174 21.8356 19.0638 21.8356 20.2231C21.8356 21.4726 21.4358 21.8591 20.159 21.8333C11.0796 21.6787 2.95464 15.238 0.81377 6.4013C0.439762 4.84264 0.323691 3.20669 0.181825 1.5965C0.0915477 0.643272 0.620317 0.179538 1.57468 0.179538C2.83857 0.166656 4.10246 0.166656 5.36635 0.166656C6.29492 0.166656 6.68183 0.591746 6.7979 1.51921C6.97845 2.88465 7.22349 4.25009 7.48143 5.60265C7.5846 6.18231 7.48143 6.64605 7.05583 7.05825C6.20464 7.88267 5.37925 8.70709 4.54095 9.54438Z"
                                            fill="#006769" />
                                    </g>
                                    <defs>
                                        <clippath id="clip0_5893_1968">
                                            <rect width="21.6667" height="21.6667" fill="white"
                                                transform="translate(0.166016 0.166656)" />
                                        </clippath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="box1-content fs-16 fw-medium lh-base text-black">
                                +1 1234567890
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-sm-6 mt-30px">
                    <a href="#" class="text-decoration-none">
                        <div class="box-1 d-flex align-items-center gap-15">
                            <div class="icon1 d-flex align-items-center justify-content-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="22"
                                    viewBox="0 0 26 22" fill="none">
                                    <g clip-path="url(#clip0_5893_1958)">
                                        <path
                                            d="M0.824791 21.8333C0.719793 21.6346 0.551797 21.4463 0.520297 21.237C0.467798 20.8604 0.520297 20.4733 0.499298 20.0967C0.488798 19.7514 0.635795 19.5736 0.992788 19.584C1.09779 19.584 1.20278 19.584 1.30778 19.584C9.10913 19.584 16.9 19.584 24.7013 19.5945C24.9638 19.5945 25.2263 19.6991 25.4888 19.7514C25.4888 20.4419 25.4888 21.1429 25.4888 21.8333C17.278 21.8333 9.04613 21.8333 0.824791 21.8333Z"
                                            fill="#006769" />
                                        <path
                                            d="M13.0253 9.03838C15.8287 9.03838 18.6322 9.03838 21.4461 9.03838C23.0316 9.03838 23.8086 9.82302 23.8191 11.4132C23.8191 11.4342 23.8191 11.4446 23.8191 11.4655C24.0081 12.3862 23.5776 12.9093 22.7586 13.265C21.9291 13.6207 21.1311 13.6939 20.4066 13.0767C20.0497 12.7733 19.7557 12.4071 19.4617 12.041C19.0732 11.5702 18.7057 11.5597 18.3067 12.02C18.0442 12.3234 17.7817 12.6268 17.4877 12.8884C16.6582 13.6312 15.7447 13.7149 14.8103 13.1185C14.3903 12.8465 14.0123 12.5013 13.6448 12.156C13.1408 11.6852 12.9203 11.6852 12.4268 12.177C12.1433 12.4594 11.8493 12.7314 11.5238 12.9616C10.4213 13.7567 9.42387 13.7044 8.39489 12.8256C8.23739 12.6896 8.09039 12.5431 7.9539 12.3862C7.25041 11.5806 7.10341 11.5806 6.39993 12.4176C5.44445 13.5475 4.23697 13.7986 2.893 13.1918C2.36801 12.9511 2.16851 12.585 2.22101 12.041C2.25251 11.7794 2.28401 11.5179 2.25251 11.2668C2.07402 9.97995 3.11349 9.01745 4.45747 9.02792C7.30291 9.0593 10.1589 9.03838 13.0253 9.03838Z"
                                            fill="#006769" />
                                        <path
                                            d="M23.6109 18.1717C16.5446 18.1717 9.50972 18.1717 2.44336 18.1717C2.44336 17.0732 2.44336 15.9747 2.44336 14.8343C4.19682 15.4202 5.72979 15.0435 6.98977 13.694C9.08973 15.7026 11.0217 15.4306 13.0481 13.6312C15.5576 15.8073 17.3636 15.3051 19.075 13.5998C19.6525 14.217 20.2825 14.782 21.1435 15.0017C21.994 15.2214 22.792 15.0435 23.6319 14.6878C23.6109 15.8596 23.6109 16.9895 23.6109 18.1717Z"
                                            fill="#006769" />
                                        <path
                                            d="M11.5241 8.05495C11.5241 7.01922 11.5136 6.00442 11.5346 4.97915C11.5451 4.64437 11.7866 4.44559 12.1331 4.44559C12.7106 4.43513 13.2881 4.43513 13.8551 4.44559C14.2541 4.44559 14.485 4.67575 14.485 5.06284C14.506 6.04626 14.4955 7.04015 14.4955 8.05495C13.4981 8.05495 12.5321 8.05495 11.5241 8.05495Z"
                                            fill="#006769" />
                                        <path
                                            d="M13.0162 0.166656C13.2682 0.626982 13.5621 1.15008 13.8456 1.68364C13.9716 1.92426 14.1396 2.16489 14.2131 2.42643C14.3706 3.00184 14.1186 3.62956 13.6671 3.88064C13.2157 4.13173 12.5227 4.0585 12.1552 3.72371C11.7667 3.35755 11.6407 2.6566 11.9137 2.14396C12.2707 1.45347 12.6592 0.783911 13.0162 0.166656Z"
                                            fill="#006769" />
                                    </g>
                                    <defs>
                                        <clippath id="clip0_5893_1958">
                                            <rect width="25" height="21.6667" fill="white"
                                                transform="translate(0.5 0.166656)" />
                                        </clippath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="box1-content fs-16 fw-medium lh-base text-black">
                                12th March, 1990
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-sm-6 mt-30px">
                    <a href="#" class="text-decoration-none">
                        <div class="box-1 d-flex align-items-center gap-15">
                            <div class="icon1 d-flex align-items-center justify-content-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="26"
                                    viewBox="0 0 20 26" fill="none">
                                    <g clip-path="url(#clip0_5893_1951)">
                                        <path
                                            d="M9.61002 21.005C9.28803 20.6277 8.97867 20.2698 8.67563 19.9086C7.04044 17.9416 5.49364 15.9069 4.15519 13.7175C3.55226 12.734 3.02508 11.7118 2.57367 10.6444C1.74345 8.67424 1.8855 6.73628 2.80096 4.85959C3.98473 2.43472 5.92612 0.990119 8.55251 0.58705C12.5931 -0.0320655 16.4317 2.86359 17.0915 6.95555C17.3061 8.29697 17.1009 9.55455 16.5864 10.7863C16.0119 12.16 15.27 13.4369 14.4619 14.6719C13.0193 16.8711 11.4062 18.9316 9.68894 20.9114C9.66999 20.934 9.6479 20.9598 9.61002 21.005ZM13.4076 7.58757C13.4107 5.45291 11.7061 3.71487 9.61317 3.71487C7.51711 3.71487 5.81563 5.44968 5.81563 7.58434C5.81563 9.719 7.51711 11.457 9.61002 11.457C11.7029 11.457 13.4044 9.72545 13.4076 7.58757Z"
                                            fill="#006769" />
                                        <path
                                            d="M6.65738 18.377C6.2912 18.4318 5.92818 18.4834 5.56831 18.5479C4.4824 18.7381 3.41858 19.0057 2.41474 19.4862C2.02331 19.6764 1.65081 19.8957 1.34461 20.215C0.852161 20.7309 0.852161 21.2597 1.35724 21.766C1.78655 22.1981 2.32004 22.4496 2.87247 22.6688C3.9426 23.088 5.06008 23.317 6.19334 23.4718C7.75592 23.6878 9.32797 23.7394 10.9032 23.662C12.6678 23.5749 14.4135 23.3492 16.096 22.7624C16.5948 22.5882 17.0809 22.3819 17.5102 22.0594C17.7028 21.9143 17.889 21.7466 18.0374 21.5564C18.3246 21.1888 18.3341 20.7792 18.0374 20.4213C17.8353 20.1763 17.586 19.9538 17.3208 19.7796C16.579 19.2927 15.7456 19.0154 14.8933 18.8155C14.1862 18.651 13.4696 18.5446 12.7562 18.4124C12.693 18.3995 12.6331 18.3899 12.5699 18.3802C12.6867 18.1287 12.7088 18.1222 12.9645 18.1416C14.0189 18.2254 15.0701 18.3415 16.1023 18.5769C16.6642 18.7026 17.2198 18.8542 17.728 19.1283C18.0468 19.2992 18.3625 19.4991 18.6245 19.7442C19.2969 20.3762 19.4169 21.2533 18.9875 22.0787C18.7571 22.5237 18.4193 22.8752 18.0342 23.1815C17.1945 23.849 16.238 24.2908 15.2342 24.6294C13.1224 25.342 10.9474 25.5774 8.73135 25.4807C7.02987 25.4033 5.36628 25.1227 3.75635 24.5359C2.76514 24.1747 1.82128 23.7233 1.01315 23.0139C0.659601 22.7043 0.359712 22.3432 0.170308 21.9014C-0.148521 21.1565 -0.00331158 20.3697 0.555429 19.7925C1.02262 19.3088 1.61293 19.0412 2.22849 18.8316C3.07134 18.5446 3.9426 18.3963 4.82017 18.2867C5.3063 18.2254 5.79244 18.1899 6.28173 18.1383C6.51848 18.1158 6.53742 18.1287 6.65738 18.377Z"
                                            fill="#006769" />
                                    </g>
                                    <defs>
                                        <clippath id="clip0_5893_1951">
                                            <rect width="19.2308" height="25" fill="white"
                                                transform="translate(0 0.5)" />
                                        </clippath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="box1-content fs-16 fw-medium lh-base text-black">
                                Barlin, Germany
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
        <div class="overflow-hidden">
            <!-- gallery-section -->
            <div class="gallery-section pb-60px position-relative  pt-60px">
                <div class="position-absolute vector-75 gallery-vector-1">
                    <img src="{{ asset('assets/img/vcard37/gallery-vector-1.png') }}" alt="images"
                        class="w-100" />
                </div>
                <div class="position-absolute vector-75 gallery-vector-3">
                    <img src="{{ asset('assets/img/vcard37/gallery-vector-3.png') }}" alt="images"
                        class="w-100" />
                </div>
                <div class="position-absolute vector-75 gallery-vector-2 text-end">
                    <img src="{{ asset('assets/img/vcard37/gallery-vector-2.png') }}" alt="images"
                        class="w-100" />
                </div>
                <div class="position-absolute vector-75 gallery-vector-4 text-end">
                    <img src="{{ asset('assets/img/vcard37/gallery-vector-4.png') }}" alt="images"
                        class="w-100" />
                </div>
                <div class="section-heading text-center mb-30px">
                    <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">
                        Gallery</p>
                </div>
                <div class="gallery-slider">
                    <div>
                        <div class="gallery-box h-100 w-100 d-flex align-items-end mx-auto mx-sm-0 overflow-hidden">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard37/gallery-img-1.png') }}" alt="images"
                                    class="h-100 w-100 object-fit-cover" />
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="gallery-box h-100 w-100 d-flex align-items-end mx-auto mx-sm-0 overflow-hidden">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard37/gallery-img-2.png') }}" alt="images"
                                    class="h-100 w-100 object-fit-cover" />
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="gallery-box h-100 w-100 d-flex align-items-end mx-auto mx-sm-0 overflow-hidden">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard37/gallery-img-3.png') }}" alt="images"
                                    class="h-100 w-100 object-fit-cover" />
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="gallery-box h-100 w-100 d-flex align-items-end mx-auto mx-sm-0 overflow-hidden">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard37/gallery-img-1.png') }}" alt="images"
                                    class="h-100 w-100 object-fit-cover" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- service-section -->
            <div class="service-section pb-60px position-relative">
                <div class="position-absolute vector-75 service-vector-1">
                    <img src="{{ asset('assets/img/vcard37/service-vector-1.png') }}" alt="images"
                        class="w-100" />
                </div>
                <div class="position-absolute vector-75 service-vector-2 text-end">
                    <img src="{{ asset('assets/img/vcard37/service-vector-2.png') }}" alt="images"
                        class="w-100" />
                </div>
                <div class="section-heading text-center mb-30px">
                    <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">
                        Our
                        Service</p>
                </div>
                <div class="service-slider">
                    <div>
                        <div class="service-box bg-white w-100 mx-auto">
                            <div class="sevice-img h-100 w-100 mb-10px">
                                <img src="{{ asset('assets/img/vcard37/service-slider-1.png') }}" alt="images"
                                    class="h-100 object-fit-cover" />
                            </div>
                            <div class="service-content">
                                <p class="mb-5px text-black">Flower Name</p>
                                <h6 class="fs-12 mb-0 text-gray">Lorem Ipsum is simply dummy
                                    text of the printing and typesetting
                                    industry. Lorem Ipsum has been the industry's.</h6>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="service-box bg-white w-100 mx-auto">
                            <div class="sevice-img h-100 w-100 mb-10px">
                                <img src="{{ asset('assets/img/vcard37/service-slider-2.png') }}" alt="images"
                                    class="h-100 object-fit-cover" />
                            </div>
                            <div class="service-content">
                                <p class="mb-5px text-black">Flower Name</p>
                                <h6 class="fs-12 mb-0 text-gray">Lorem Ipsum is simply dummy
                                    text of the printing and typesetting
                                    industry. Lorem Ipsum has been the industry's.</h6>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="service-box bg-white w-100 mx-auto">
                            <div class="sevice-img h-100 w-100 mb-10px">
                                <img src="{{ asset('assets/img/vcard37/service-slider-1.png') }}" alt="images"
                                    class="h-100 object-fit-cover" />
                            </div>
                            <div class="service-content">
                                <p class="mb-5px text-black">Flower Name</p>
                                <h6 class="fs-12 mb-0 text-gray">Lorem Ipsum is simply dummy
                                    text of the printing and typesetting
                                    industry. Lorem Ipsum has been the industry's.</h6>
                            </div>
                        </div>

                    </div>
                    <div>
                        <div class="service-box bg-white w-100 mx-auto">
                            <div class="sevice-img h-100 w-100 mb-10px">
                                <img src="{{ asset('assets/img/vcard37/service-slider-2.png') }}" alt="images"
                                    class="h-100  object-fit-cover" />
                            </div>
                            <div class="service-content">
                                <p class="mb-5px text-black">Flower Name</p>
                                <h6 class="fs-12 mb-0 text-gray">Lorem Ipsum is simply dummy
                                    text of the printing and typesetting
                                    industry. Lorem Ipsum has been the industry's.</h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- appointment-section -->
            <div class="appointment-section">
                <div class="section-heading text-center mb-30px px-30px">
                    <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">
                        Make
                        a Appointment</p>
                </div>
                <div class="appointment-bg position-relative">
                    <div class="overlay"></div>
                    <form class="position-relative">
                        <label class="fs-18 fw-semibold lh-12 text-white mb-10px">Date
                            :</label>
                        <div class="input-group align-items-center position-relative date bg-transparent mb-20px"
                            id="date-input">
                            <input type="text"
                                class="form-control p-0 fw-medium fs-14 lh-sm text-white bg-transparent border-0 rounded-0"
                                placeholder="Pick a date" />
                            <div class="input-group-prepend">
                                <span class="input-group-text border-0 p-0 rounded-0 bg-transparent ms-1" id>
                                    <img src="{{ asset('assets/img/vcard37/calender.svg') }}" alt="image" />
                                </span>
                            </div>
                        </div>
                        <div class="mb-40px">
                            <label class="fs-18 fw-semibold lh-12 text-white mb-10px">Hour:</label>
                            <div class="container px-sm-1 px-0">
                                <div class="row">
                                    <div class="col-sm-3 col-6 px-7px mb-sm-0 mb-3">
                                        <div class="hour-time text-center">
                                            <h2 class="fs-14 lh-15 text-white mb-0">8:10 -
                                                20:00</h2>
                                        </div>
                                    </div>
                                    <div class="col-sm-3 col-6 px-7px mb-sm-0 mb-3">
                                        <div class="hour-time text-center">
                                            <h2 class="fs-14 lh-15 text-white mb-0">8:10 -
                                                20:00</h2>
                                        </div>
                                    </div>
                                    <div class="col-sm-3 col-6 px-7px">
                                        <div class="hour-time text-center">
                                            <h2 class="fs-14 lh-15 text-white mb-0">8:10 -
                                                20:00</h2>
                                        </div>
                                    </div>
                                    <div class="col-sm-3 col-6 px-7px">
                                        <div class="hour-time text-center">
                                            <h2 class="fs-14 lh-15 text-white mb-0">8:10 -
                                                20:00</h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <button class="btn btn-primary fs-18 fw-semibold appointment-btn mx-auto">
                                Make An Appointment
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- product-section -->
        <div class="product-section px-30px position-relative pt-60px">
            <div class="position-absolute vector-75 product-vector-1">
                <img src="{{ asset('assets/img/vcard37/product-vector-1.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute vector-75 product-vector-2">
                <img src="{{ asset('assets/img/vcard37/product-vector-2.png') }}" alt="images" class="w-100" />
            </div>
            <div class="section-heading text-center mb-30px px-30px">
                <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">
                    Product</p>
            </div>
            <div class="product-slider">
                <div>
                    <div class="product-box w-100 mx-auto">
                        <div class="product-img h-100 w-100 mb-15px">
                            <img src="{{ asset('assets/img/vcard37/product-slider-1.png') }}" alt="images"
                                class="h-100 w-100 object-fit-cover" />
                        </div>
                        <div class="product-content">
                            <div class="d-flex align-items-center gap-2 justify-content-between mb-2">
                                <p class="fs-18 fw-semibold text-black mb-0 w-75">Flower
                                    Name</p>
                                <p class="fs-18 fw-semibold text-black mb-0">$25.00</p>
                            </div>
                            <p class="text-gray fs-14 fw-medium mb-0 lh-12 product-desc">Lorem
                                Ipsum dummy text</p>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="product-box w-100 mx-auto">
                        <div class="product-img h-100 w-100 mb-15px">
                            <img src="{{ asset('assets/img/vcard37/product-slider-2.png') }}" alt="images"
                                class="h-100 w-100 object-fit-cover" />
                        </div>
                        <div class="product-content">
                            <div class="d-flex align-items-center gap-2 justify-content-between mb-2">
                                <p class="fs-18 fw-semibold text-black mb-0 w-75">Flower
                                    Name</p>
                                <p class="fs-18 fw-semibold text-black mb-0">$25.00</p>
                            </div>
                            <p class="text-gray fs-14 fw-medium mb-0 lh-12 product-desc">Lorem
                                Ipsum dummy text</p>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="product-box w-100 mx-auto">
                        <div class="product-img h-100 w-100 mb-15px">
                            <img src="{{ asset('assets/img/vcard37/product-slider-1.png') }}" alt="images"
                                class="h-100 w-100 object-fit-cover" />
                        </div>
                        <div class="product-content">
                            <div class="d-flex align-items-center gap-2 justify-content-between mb-2">
                                <p class="fs-18 fw-semibold text-black mb-0 w-75">Flower
                                    Name</p>
                                <p class="fs-18 fw-semibold text-black mb-0">$25.00</p>
                            </div>
                            <p class="text-gray fs-14 fw-medium mb-0 lh-12 product-desc">Lorem
                                Ipsum dummy text</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- testimonial-section -->
        <div class="testimonial-section px-30px pt-60px position-relative">
            <div class="position-absolute vector-75 testimonial-vector-1 text-end">
                <img src="{{ asset('assets/img/vcard37/testimonial-vector.png') }}" alt="images" class="w-100" />
            </div>
            <div class="section-heading text-center mb-30px px-30px">
                <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">
                    Testimonial</p>
            </div>
            <div class="testimonial-slider">
                <div>
                    <div class="testimonial-box bg-white">
                        <div class="d-block d-sm-flex gap-1">
                            <div
                                class="testimonial-box-img h-100 w-100 d-flex justify-content-center align-items-center mx-auto">
                                <div class="position-relative testimonial-vector z-0">
                                    <img src="{{ asset('assets/img/vcard37/testimonial-vector-1.png') }}"
                                        alt="images" class="w-100" />
                                    <div class="testimonial-img position-absolute">

                                        <img src="{{ asset('assets/img/vcard37/testimonial-img.png') }}"
                                            alt="image" class="h-100 w-100 object-fit-cover" />
                                    </div>
                                </div>

                            </div>
                            <div>
                                <p
                                    class="fs-14 text-gray fw-medium lh-base mb-20px text-center text-sm-start testiimonial-desc">
                                    Lorem
                                    Ipsum is simply dummy text of the printing
                                    and typesetting industry. Lorem Ipsum has been the
                                    industry's standard dummy text.
                                </p>
                                <p class="fs-18 fw-semibold mb-0 text-black-100 lh-12 text-center text-sm-start">Ronald
                                    Richards</p>
                                <p class="fs-12 fw-normal mb-0 text-teal-green text-center text-sm-start">-
                                    Customer</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="testimonial-box bg-white">
                        <div class="d-block d-sm-flex gap-1">
                            <div
                                class="testimonial-box-img h-100 w-100 d-flex justify-content-center align-items-center mx-auto">
                                <div class="position-relative testimonial-vector z-0">
                                    <img src="{{ asset('assets/img/vcard37/testimonial-vector-1.png') }}"
                                        alt="images" class="w-100" />
                                    <div class="testimonial-img position-absolute">

                                        <img src="{{ asset('assets/img/vcard37/testimonial-img.png') }}"
                                            alt="image" class="h-100 w-100 object-fit-cover" />
                                    </div>
                                </div>

                            </div>
                            <div>
                                <p
                                    class="fs-14 text-gray fw-medium lh-base mb-20px text-center text-sm-start testiimonial-desc">
                                    Lorem
                                    Ipsum is simply dummy text of the printing
                                    and typesetting industry. Lorem Ipsum has been the
                                    industry's standard dummy text.
                                </p>
                                <p class="fs-18 fw-semibold mb-0 text-black-100 lh-12 text-center text-sm-start">Ronald
                                    Richards</p>
                                <p class="fs-12 fw-normal mb-0 text-teal-green text-center text-sm-start">-
                                    Customer</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- blog-section -->
        <div class="blog-section px-30px pt-60px position-relative">
            <div class="position-absolute vector-75 blog-vector-1">
                <img src="{{ asset('assets/img/vcard37/blog-vector-1.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute vector-75 blog-vector-2">
                <img src="{{ asset('assets/img/vcard37/blog-vector-2.png') }}" alt="images" class="w-100" />
            </div>
            <div class="section-heading text-center mb-30px px-30px">
                <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">Blog
                </p>
            </div>
            <div class="position-relative">
                <div class="align-tems-center gap-20 position-absolute arrow-slide-all d-none d-sm-flex">
                    <button class="prev arrow-slide d-flex align-items-center justify-content-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="10" viewBox="0 0 12 10"
                            fill="none">
                            <path
                                d="M5.32018 9.26017C5.15944 9.41373 4.94146 9.5 4.71417 9.5C4.48689 9.5 4.26891 9.41373 4.10816 9.26017L0.250963 5.57417C0.090271 5.42056 0 5.21225 0 4.99505C0 4.77786 0.090271 4.56955 0.250963 4.41594L4.10816 0.729935C4.26983 0.580727 4.48635 0.498165 4.71109 0.500031C4.93583 0.501898 5.15082 0.588042 5.30974 0.739912C5.46867 0.891783 5.55881 1.09723 5.56076 1.312C5.56272 1.52676 5.47632 1.73367 5.32018 1.88816L2.99986 4.17594L11.1428 4.17594C11.3702 4.17594 11.5882 4.26224 11.7489 4.41585C11.9097 4.56947 12 4.77781 12 4.99505C12 5.2123 11.9097 5.42064 11.7489 5.57425C11.5882 5.72787 11.3702 5.81417 11.1428 5.81417L2.99986 5.81417L5.32018 8.10195C5.48088 8.25556 5.57115 8.46386 5.57115 8.68106C5.57115 8.89826 5.48088 9.10657 5.32018 9.26017Z"
                                fill="currentColor" />
                        </svg>
                    </button>
                    <button class="next arrow-slide d-flex align-items-center justify-content-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="10" viewBox="0 0 12 10"
                            fill="none">
                            <path
                                d="M6.67982 0.739825C6.84056 0.586265 7.05854 0.5 7.28583 0.5C7.51311 0.5 7.73109 0.586265 7.89184 0.739825L11.749 4.42583C11.9097 4.57944 12 4.78775 12 5.00495C12 5.22214 11.9097 5.43045 11.749 5.58406L7.89184 9.27007C7.73017 9.41927 7.51365 9.50183 7.28891 9.49997C7.06417 9.4981 6.84918 9.41196 6.69026 9.26009C6.53133 9.10822 6.44119 8.90277 6.43924 8.688C6.43728 8.47324 6.52368 8.26633 6.67982 8.11184L9.00014 5.82406H0.857156C0.629824 5.82406 0.411803 5.73776 0.251055 5.58415C0.0903073 5.43053 0 5.22219 0 5.00495C0 4.7877 0.0903073 4.57936 0.251055 4.42575C0.411803 4.27213 0.629824 4.18583 0.857156 4.18583H9.00014L6.67982 1.89805C6.51912 1.74444 6.42885 1.53614 6.42885 1.31894C6.42885 1.10174 6.51912 0.893431 6.67982 0.739825Z"
                                fill="currentColor" />
                        </svg>
                    </button>
                </div>
                <div class="blog-slider">
                    <div>
                        <div class="blog-box row align-items-center m-0 flex-column-reverse flex-sm-row">
                            <div class="col-sm-6 p-0">
                                <div class="blog-content w-100">
                                    <p class="fs-20 fw-semibold text-black mb-15px text-center text-sm-start">Lorem
                                        Ipsum</p>
                                    <p class="fs-14 fw-medium text-black mb-15px text-center text-sm-start">Lorem
                                        Ipsum is
                                        simply dummy text of the printing and type setting
                                        industry.
                                        Lorem Ipsum has been the industry's standard.</p>
                                </div>
                            </div>
                            <div class="col-sm-6 p-0 mb-2 mb-sm-0">
                                <div class="blog-img-box mx-auto">
                                    <div class="blog-img position-relative w-100 h-100 mx-auto">
                                        <img src="{{ asset('assets/img/vcard37/blog-img.png') }}" alt="images"
                                            class="h-100 w-100 object-fit-cover" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="blog-box row align-items-center m-0 flex-column-reverse flex-sm-row">
                            <div class="col-sm-6 p-0">
                                <div class="blog-content w-100">
                                    <p class="fs-20 fw-semibold text-black mb-15px text-center text-sm-start">Lorem
                                        Ipsum</p>
                                    <p class="fs-14 fw-medium text-black mb-15px text-center text-sm-start">Lorem
                                        Ipsum is
                                        simply dummy text of the printing and type setting
                                        industry.
                                        Lorem Ipsum has been the industry's standard.</p>
                                </div>
                            </div>
                            <div class="col-sm-6 p-0 mb-2 mb-sm-0">
                                <div class="blog-img-box mx-auto">
                                    <div class="blog-img position-relative w-100 h-100 mx-auto">
                                        <img src="{{ asset('assets/img/vcard37/blog-img.png') }}" alt="images"
                                            class="h-100 w-100 object-fit-cover" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- business-section -->
        <div class="business-section px-30px pt-60px position-relative">
            <div class="position-absolute vector-75 business-vector text-end">
                <img src="{{ asset('assets/img/vcard37/business-vector.png') }}" alt="images" class="w-100" />
            </div>
            <div class="section-heading text-center mb-30px px-30px">
                <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">
                    Business
                    Hours</p>
            </div>
            <div class="business-box">
                <div class="d-sm-flex d-block justify-content-between align-items-center">
                    <p class="fs-18 fw-semibold text-black mb-25px text-center texts-sm-start">Sunday
                        : 08:10 - 20:00</p>
                    <p class="fs-18 fw-semibold text-black mb-25px text-center texts-sm-start">Monday
                        : 08:10 - 20:00</p>
                </div>
                <div class="d-sm-flex d-block justify-content-between align-items-center">
                    <p class="fs-18 fw-semibold text-black mb-25px text-center texts-sm-start">Tuesday
                        : 08:10 - 20:00
                    </p>
                    <p class="fs-18 fw-semibold text-black mb-25px text-center texts-sm-start">Wednesday
                        : 08:10 - 10:00</p>
                </div>
                <div class="d-sm-flex d-block justify-content-between align-items-center">
                    <p class="fs-18 fw-semibold text-black mb-25px text-center texts-sm-start">Thursday
                        : 08:10 - 20:00</p>
                    <p class="fs-18 fw-semibold text-black mb-25px text-center texts-sm-start">Friday
                        : 08:10 - 20:00</p>
                </div>
                <p class="fs-18 fw-semibold text-black mb-0 text-center">Saturday :
                    Closed</p>
            </div>
        </div>
        <!-- qr-section -->
        <div class="qr-section pt-60px position-relative">
            <div class="position-absolute vector-75 qr-vector">
                <img src="{{ asset('assets/img/vcard37/qr-vector.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute vector-75 qr-vector-1 text-end">
                <img src="{{ asset('assets/img/vcard37/qr-vector-1.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute vector-75 qr-vector-2 text-end">
                <img src="{{ asset('assets/img/vcard37/qr-vector-2.png') }}" alt="images" class="w-100" />
            </div>
            <div class="section-heading text-center mb-30px px-30px">
                <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">QR
                    Code</p>
            </div>
            <div class="qr-bg">
                <div class="qr-code-section w-100 mx-auto ms-sm-auto me-sm-0 text-center">
                    <div class="qr-img bg-white mx-auto h-100 w-100 mb-30px">
                        <img src="{{ asset('assets/img/vcard37/qr-code.png') }}" alt="images"
                            class="h-100 w-100 object-fit-cover" />
                    </div>
                </div>
            </div>
        </div>
        <!-- contact-us-section -->
        <div class="contact-us-section px-30px pt-60px position-relative">
            <div class="position-absolute vector-75 contact-vector-1">
                <img src="{{ asset('assets/img/vcard37/contact-vector-1.png') }}" alt="images" class="w-100" />
            </div>
            <div class="position-absolute vector-75 contact-vector-2 text-end">
                <img src="{{ asset('assets/img/vcard37/contact-vector-2.png') }}" alt="images" class="w-100" />
            </div>
            <div class="section-heading text-center mb-30px">
                <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">
                    Contact
                    Us</p>
            </div>
            <form>
                <div class="mb-15px">
                    <input type="text" class="form-control text-gray fs-16 fw-semibold border-0"
                        placeholder="Full Name" required />
                </div>
                <div class="mb-15px">
                    <input type="text" class="form-control text-gray fs-16 fw-semibold border-0"
                        placeholder="Email Address" required />
                </div>
                <div class="mb-15px">
                    <input type="text" class="form-control text-gray fs-16 fw-semibold border-0"
                        placeholder="Phone Number" required />
                </div>
                <div class="mb-30px">
                    <textarea rows="3" class="form-control text-gray fs-16 fw-semibold border-0" placeholder="Your Message"
                        required></textarea>
                </div>
                <div class="text-center">
                    <button class="fs-16 fw-semibold send-btn btn btn-primary lh-11" type="submit">Send
                        Message</button>
                </div>
            </form>
        </div>
        <!-- Create Your vCard -->
        <div class="your-vcard-section px-30px pt-60px position-relative">
            <div class="position-absolute vector-75 your-vcard-vector-1">
                <img src="{{ asset('assets/img/vcard37/your-vcrad-vector-1.png') }}" alt="images"
                    class="w-100" />
            </div>
            <div class="position-absolute vector-75 your-vcard-vector-2">
                <img src="{{ asset('assets/img/vcard37/your-vcrad-vector-2.png') }}" alt="images"
                    class="w-100" />
            </div>
            <div class="section-heading text-center mb-30px">
                <p class="text-teal-green text-center fs-26 fw-bold d-inline-block position-relative mb-0 lh-normal">
                    Create
                    Your vCard</p>
            </div>
            <div class="your-vacrd-bg position-relative">
                <div
                    class="input-group v-card-input bg-transparent w-100 d-flex justify-content-center gap-20 align-items-center flex-nowrap position-relative mx-auto z-1">
                    <a class="text-black fs-16 lh-base text-wrap fw-semibold text-decoration-none" href="#">
                        https://vcards.infyom.com/marlonbrasil
                    </a>
                    <div class="input-group-append">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                            fill="none">
                            <path
                                d="M14.3965 7.95047H13.2665C13.0325 7.95047 12.8428 8.14019 12.8428 8.37421V13.5261C12.8428 13.7996 12.6203 14.0221 12.3468 14.0221H2.47324C2.19984 14.0221 1.97746 13.7996 1.97746 13.5261V3.65272C1.97746 3.37921 2.19984 3.15666 2.47324 3.15666H7.88893C8.12295 3.15666 8.31267 2.96693 8.31267 2.73292V1.60294C8.31267 1.36892 8.12295 1.1792 7.88893 1.1792H2.47324C1.10947 1.1792 0 2.28884 0 3.65272V13.5262C0 14.89 1.10952 15.9996 2.47324 15.9996H12.3467C13.7106 15.9996 14.8202 14.89 14.8202 13.5262V8.37427C14.8203 8.14019 14.6305 7.95047 14.3965 7.95047Z"
                                fill="black" />
                            <path
                                d="M15.5764 0.000488281H11.0818C10.8477 0.000488281 10.658 0.190211 10.658 0.424229V1.55421C10.658 1.78822 10.8477 1.97795 11.0818 1.97795H12.6244L6.81943 7.7828C6.65394 7.94829 6.65394 8.21655 6.81943 8.38209L7.61843 9.18115C7.69793 9.26064 7.80567 9.30528 7.9181 9.30528C8.03048 9.30528 8.13828 9.26064 8.21772 9.18115L14.0227 3.37618V4.91877C14.0227 5.15278 14.2124 5.34251 14.4464 5.34251H15.5764C15.8104 5.34251 16.0001 5.15278 16.0001 4.91877V0.424229C16.0001 0.190211 15.8104 0.000488281 15.5764 0.000488281Z"
                                fill="black" />
                        </svg>
                    </div>
                </div>
            </div>
        </div>
        <!-- add-section -->
        <div class="add-section">
            <div class="addcard text-center">
                <a href="#"
                    class="z-2 btn btn-primary text-white fw-semibold fs-16 lh-base add-btn position-fixed start-0 end-0 mx-auto"
                    type="submit">Add to Contact</a>
            </div>
        </div>
    </div>
    <!-- bootstrap script  -->
    {{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap-datepicker.min.js') }}"></script> --}}
    <script src="https://js.stripe.com/v3/"></script>
    <script type="text/javascript" src="{{ asset('assets/js/front-third-party.js') }}"></script>
    <script type="text/javascript" src="{{ asset('front/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/js/slider/js/slick.min.js') }}" type="text/javascript"></script>
    <script>
        let social = document.querySelector(".social");
        let closeBtn = document.querySelector(".btn1");
        closeBtn.addEventListener("click", () => {
            social.classList.toggle("close");
        });
        $(".testimonial-slider").slick({
            slidesToShow: 1,
            infinite: true,
            slidesToScroll: 1,
            autoplay: false,
            autoplaySpeed: 1000,
            arrows: false,
            dots: false,
            responsive: [{
                breakpoint: 575,
                settings: {
                    dots: true
                },
            }, ],
        });
        $(document).ready(function() {
            $('#date-input').datepicker({
                format: 'dd-mm-yyyy'
            });
        });
        $(".gallery-slider").slick({
            dots: true,
            centerMode: true,
            centerPadding: "160px",
            infinite: true,
            speed: 300,
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: false,
            autoplaySpeed: 1000,
            arrows: false,
            responsive: [{
                breakpoint: 575,
                settings: {
                    centerPadding: "0",

                },
            }, ],
        });
        $(".service-slider").slick({
            dots: true,
            centerMode: true,
            centerPadding: "164px",
            infinite: true,
            speed: 300,
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: false,
            autoplaySpeed: 1000,
            arrows: false,
            responsive: [{
                breakpoint: 575,
                settings: {
                    centerPadding: "0",

                },
            }, ],
        });
        $(".product-slider").slick({
            slidesToShow: 2,
            infinite: true,
            slidesToScroll: 1,
            autoplay: true,
            autoplaySpeed: 1000,
            arrows: false,
            dots: false,
            responsive: [{
                breakpoint: 575,
                settings: {
                    slidesToShow: 1,
                    dots: true
                },
            }, ],
        });
        $(".blog-slider").slick({
            slidesToShow: 1,
            infinite: true,
            slidesToScroll: 1,
            autoplay: true,
            autoplaySpeed: 1000,
            arrows: true,
            prevArrow: $('.prev'),
            nextArrow: $('.next'),
            dots: false,
            responsive: [{
                breakpoint: 575,
                settings: {
                    dots: true,
                    arrows: false,
                },
            }, ],
        });
    </script>
</body>

</html>
